package ru.yandex.direct.core.entity.banner.type.phone;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndPhone;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.container.BannerOperationContainerUtils.needToCheckPermalinkAccessForAdd;
import static ru.yandex.direct.core.entity.banner.container.BannerOperationContainerUtils.needToCheckPermalinkAccessForUpdate;

@Component
@ParametersAreNonnullByDefault
public class BannerWithOrganizationAndPhoneValidatorProvider {

    public ListItemValidator<BannerWithOrganizationAndPhone, Defect> addValidator(
            BannersAddOperationContainer container,
            List<BannerWithOrganizationAndPhone> models
    ) {
        var phoneIdsContainer = container.getAllowedPhoneIds();

        boolean allowOverrideNotManual = phoneIdsContainer.isAllowedOverrideNotManual();

        var accessibleOrganizations = container.getAccessibleOrganizationsPermalinkId();

        return (index, banner) -> {
            ModelItemValidationBuilder<BannerWithOrganizationAndPhone> ivb = ModelItemValidationBuilder.of(banner);
            boolean needToCheckPermalinkAccess = !container.isCopy()
                    && needToCheckPermalinkAccessForAdd(banner, phoneIdsContainer, container, allowOverrideNotManual);
            ivb.item(BannerWithOrganizationAndPhone.PHONE_ID)
                    .checkBy(new PhoneIdValidator(banner.getPermalinkId(),
                            accessibleOrganizations, phoneIdsContainer, needToCheckPermalinkAccess, container.isCopy()));
            return ivb.getResult();
        };
    }

    public ListItemValidator<BannerWithOrganizationAndPhone, Defect> updateValidator(
            BannersUpdateOperationContainer container,
            Map<Integer, AppliedChanges<BannerWithOrganizationAndPhone>> appliedChanges
    ) {
        var phoneIdsContainer = container.getAllowedPhoneIds();

        boolean allowOverrideNotManual = phoneIdsContainer.isAllowedOverrideNotManual();

        var accessiblePermalinks = container.getAccessibleOrganizationsPermalinkId();
        return (index, banner) -> {
            ModelItemValidationBuilder<BannerWithOrganizationAndPhone> ivb = ModelItemValidationBuilder.of(banner);
            boolean needToCheckPermalinkAccess = appliedChanges.isEmpty() || needToCheckPermalinkAccessForUpdate(
                    appliedChanges.get(index), phoneIdsContainer, container, allowOverrideNotManual
            );
            ivb.item(BannerWithOrganizationAndPhone.PHONE_ID)
                    .checkBy(new PhoneIdValidator(banner.getPermalinkId(),
                            accessiblePermalinks, phoneIdsContainer, needToCheckPermalinkAccess, false));
            return ivb.getResult();
        };
    }
}
