package ru.yandex.direct.core.entity.banner.type.phone;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPhone;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractRelatedSingleFieldRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerPhonesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PHONES;

@Component
@ParametersAreNonnullByDefault
public class BannerWithPhoneRepositoryTypeSupport
        extends AbstractRelatedSingleFieldRepositoryTypeSupport<BannerWithPhone, Long, BannerPhonesRecord, Long> {

    private static final Set<ModelProperty<? super BannerWithPhone, ?>> GRUT_PROPERTIES =
            Set.of(BannerWithPhone.PHONE_ID);

    @Autowired
    public BannerWithPhoneRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,
                BannerWithPhone.PHONE_ID,
                BANNER_PHONES.BID,
                BANNER_PHONES.CLIENT_PHONE_ID,
                Function.identity(),
                Function.identity());
    }

    @Override
    public Class<BannerWithPhone> getTypeClass() {
        return BannerWithPhone.class;
    }

    @Override
    public Set<ModelProperty<? super BannerWithPhone, ?>> getGrutSupportedProperties() {
        return GRUT_PROPERTIES;
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(
            @NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
            @NotNull Collection<AppliedChanges<BannerWithPhone>> appliedChangesList,
            @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (var appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithPhone.PHONE_ID)) {
                Long id = appliedChanges.getModel().getId();
                ModifiedPaths modifiedPaths;
                var newValue = appliedChanges.getNewValue(BannerWithPhone.PHONE_ID);
                if (newValue != null) {
                    Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                    bannerBuilder.getSpecBuilder().getPermalinkBuilder().setPhoneId(newValue);
                    modifiedPaths = new ModifiedPaths(Set.of("/spec/permalink/phone_id"), emptySet());
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/permalink/phone_id"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
