package ru.yandex.direct.core.entity.banner.type.phone;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithPhone;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithPhoneUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithPhone> {

    @Override
    public Class<BannerWithPhone> getTypeClass() {
        return BannerWithPhone.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithPhone> appliedChanges) {
        return appliedChanges.changed(BannerWithPhone.PHONE_ID);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithPhone> appliedChanges) {
        return appliedChanges.changed(BannerWithPhone.PHONE_ID);
    }

}
