package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.utils.CollectionUtils;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.invalidPixelWithMeasurer;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstants.MEASURER_TO_PIXELS_MAP;

public class BannerPixelsAndMeasurersConstraints {
    private BannerPixelsAndMeasurersConstraints() {
    }

    public static Constraint<String, Defect> checkPixelWithMeasurer(
            List<BannerMeasurer> bannerMeasurers, Set<PixelProvider> accessibleProviders) {
        return pixel -> {
            if (!CollectionUtils.isEmpty(bannerMeasurers)
                    && pixel != null
                    && PixelProvider.fromUrl(pixel) != null
                    && accessibleProviders.contains(PixelProvider.fromUrl(pixel))
            ) {
                var pixelProvider = PixelProvider.fromUrl(pixel);
                for (var entry : MEASURER_TO_PIXELS_MAP.entrySet()) {
                    var hasMeasurer = bannerMeasurers.stream()
                            .anyMatch(m -> entry.getKey().equals(m.getBannerMeasurerSystem()));
                    if (hasMeasurer && entry.getValue().contains(pixelProvider)) {
                        return invalidPixelWithMeasurer(pixel, entry.getKey().name());
                    }
                }
            }
            return null;
        };
    }
}
