package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

public class BannerPixelsAndMeasurersValidator implements DefaultValidator<List<String>> {
    private final List<BannerMeasurer> bannerMeasurers;
    private final Set<PixelProvider> accessibleProviders;

    public BannerPixelsAndMeasurersValidator(List<BannerMeasurer> bannerMeasurers,
                                                Set<PixelProvider> accessibleProviders) {
        this.bannerMeasurers = bannerMeasurers;
        this.accessibleProviders = accessibleProviders;
    }

    @Override
    public ValidationResult<List<String>, Defect> apply(List<String> pixels) {
        ListValidationBuilder<String, Defect> vb = ListValidationBuilder.of(pixels);
        vb.checkEach(BannerPixelsAndMeasurersConstraints.checkPixelWithMeasurer(bannerMeasurers, accessibleProviders));
        return vb.getResult();
    }
}
