package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.banner.model.BannerMeasurerSystem;

public class BannerPixelsConstants {
    public static final Map<BannerMeasurerSystem, List<PixelProvider>> MEASURER_TO_PIXELS_MAP = Map.of(
            BannerMeasurerSystem.SIZMEK, List.of(PixelProvider.SIZMEK),
            BannerMeasurerSystem.ADRIVER, List.of(PixelProvider.ADRIVER),
            BannerMeasurerSystem.MEDIASCOPE, List.of(PixelProvider.MEDIASCOPE, PixelProvider.TNS),
            BannerMeasurerSystem.WEBORAMA, List.of(PixelProvider.WEBORAMA)
    );


    /**
     * Максимальное кол-во пикселей, не являющих пикселями Я.аудиторий, на одном баннере. Для видео-аудио.
     */
    public static final Integer MAX_NOT_YA_AUDIENCE_PIXELS_COUNT_ON_BANNER_VIDEO_AUDIO = 1;

    /**
     * Максимальное количество пикселей одного провайдера на баннере
     */
    public static final Integer MAX_EQUAL_PROVIDERS_ON_BANNER = 1;
    /**
     * Дефолтное максимальное кол-во пикселей, не являющих пикселями Я.аудиторий, на одном баннере
     */
    public static final Integer MAX_NOT_YA_AUDIENCE_PIXELS_COUNT_ON_BANNER_DEFAULT = 4;
    /**
     * Максимальное кол-во пикселей Я.аудиторий на одном баннере
     */
    public static final Integer MAX_YA_AUDIENCE_PIXELS_COUNT_ON_BANNER = 1;

    private BannerPixelsConstants() {
    }
}
