package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstraints.maxNumberOfNotYaAudiencePixels;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstraints.maxNumberOfSamePixelProviders;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstraints.maxNumberOfYaAudiencePixels;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstraints.validPermissionsForProvider;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstraints.validPermissionsForYaAudienceProvider;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstraints.validPixelFormat;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerWithPixelsValidatorHelper.getAccessiblePixelProviderNames;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerWithPixelsValidatorHelper.getAccessiblePixelProviders;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class BannerPixelsValidator implements Validator<List<String>, Defect> {
    private final NewPixelsValidationContext context;

    public BannerPixelsValidator(NewPixelsValidationContext context) {
        this.context = context;
    }

    public static BannerPixelsValidator bannerPixelsValidator(NewPixelsValidationContext context) {
        return new BannerPixelsValidator(context);
    }

    @Override
    public ValidationResult<List<String>, Defect> apply(List<String> pixels) {
        var adGroupType = context.getAdGroupType();
        ListValidationBuilder<String, Defect> lvb = ListValidationBuilder.of(pixels);
        lvb
                .check(maxNumberOfNotYaAudiencePixels(adGroupType), When.isValid())
                .check(maxNumberOfYaAudiencePixels(), When.isValid())
                .check(maxNumberOfSamePixelProviders(getAccessiblePixelProviderNames(context)), When.isValid())
                .checkEachBy(pixelUrl -> validatePixel(pixelUrl, getAccessiblePixelProviders(context)), When.isValid());
        return lvb.getResult();
    }

    private static ValidationResult<String, Defect> validatePixel(String pixelUrl, Set<PixelProvider> accessibleProviders) {
        return ItemValidationBuilder.<String, Defect>of(pixelUrl)
                .check(notNull())
                .check(validPixelFormat(), When.isValid())
                .check(validPermissionsForYaAudienceProvider(accessibleProviders), When.isValid())
                .check(validPermissionsForProvider(accessibleProviders), When.isValid())
                .getResult();
    }
}
