package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPixels;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithPixelsAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithPixels> {
    private final BannerWithPixelsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithPixelsAddValidationTypeSupport(BannerWithPixelsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithPixels>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithPixels>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container, vr.getValue()))
                .getResult();
    }

    @Override
    public Class<BannerWithPixels> getTypeClass() {
        return BannerWithPixels.class;
    }
}
