package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPixelsAndMeasurers;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithPixelsAndMeasurersUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithPixelsAndMeasurers> {
    private final BannerWithPixelsAndMeasurersValidatorProvider validatorProvider;

    @Autowired
    public BannerWithPixelsAndMeasurersUpdateValidationTypeSupport(BannerWithPixelsAndMeasurersValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithPixelsAndMeasurers> getTypeClass() {
        return BannerWithPixelsAndMeasurers.class;
    }

    @Override
    public ValidationResult<List<BannerWithPixelsAndMeasurers>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithPixelsAndMeasurers>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container, vr.getValue()))
                .getResult();
    }
}
