package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPixelsAndMeasurers;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static java.util.function.Function.identity;
import static ru.yandex.direct.core.entity.banner.type.pixels.BannerWithPixelsValidatorHelper.getAccessiblePixelProviders;

@Component
public class BannerWithPixelsAndMeasurersValidatorProvider {
    private final BannerWithPixelsValidatorProvider bannerWithPixelsValidatorProvider;

    public BannerWithPixelsAndMeasurersValidatorProvider(BannerWithPixelsValidatorProvider bannerWithPixelsValidatorProvider) {
        this.bannerWithPixelsValidatorProvider = bannerWithPixelsValidatorProvider;
    }

    public ListItemValidator<BannerWithPixelsAndMeasurers, Defect> validator(BannersOperationContainer container,
                                                                             List<BannerWithPixelsAndMeasurers> banners) {
        var pixelsValidationContextMap =
                bannerWithPixelsValidatorProvider.collectPixelsValidationContext(container, banners);

        IdentityHashMap<BannerWithPixelsAndMeasurers, Set<PixelProvider>> accessibleProviders =
                StreamEx.of(banners)
                        .mapToEntry(identity(), it -> getAccessiblePixelProviders(pixelsValidationContextMap.get(it)))
                        .toCustomMap(IdentityHashMap::new);

        return (index, banner) -> {
            ModelItemValidationBuilder<BannerWithPixelsAndMeasurers> ivb =
                    ModelItemValidationBuilder.of(banner);
            ivb.item(BannerWithPixelsAndMeasurers.PIXELS)
                    .checkBy(new BannerPixelsAndMeasurersValidator(banner.getMeasurers(),
                            accessibleProviders.get(banner)));
            return ivb.getResult();
        };
    }
}
