package ru.yandex.direct.core.entity.banner.type.pixels;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithPixels;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.pixels.BannerWithPixelsUtils.isBannerPixelsChanged;

@Component
@ParametersAreNonnullByDefault
public class BannerWithPixelsUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithPixels> {
    @Override
    public Class<BannerWithPixels> getTypeClass() {
        return BannerWithPixels.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithPixels> appliedChanges) {
        return isBannerPixelsChanged(appliedChanges);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithPixels> appliedChanges) {
        return isBannerPixelsChanged(appliedChanges);
    }
}
