package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerWithPixels;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptySet;
import static java.util.function.Function.identity;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@ParametersAreNonnullByDefault
public class BannerWithPixelsUtils {
    private BannerWithPixelsUtils() {
    }

    public static boolean isBannerPixelsChanged(@Nonnull AppliedChanges<? extends BannerWithPixels> ac) {
        Set<String> oldValue = normalizePixels(ac.getOldValue(BannerWithPixels.PIXELS));
        Set<String> newValue = normalizePixels(ac.getNewValue(BannerWithPixels.PIXELS));
        return !Objects.equals(oldValue, newValue);
    }

    private static Set<String> normalizePixels(@Nullable List<String> pixels) {
        return nvl(listToSet(pixels, identity()), emptySet());
    }
}
