package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;

public class BannerWithPixelsValidatorHelper {
    private BannerWithPixelsValidatorHelper() {
    }

    /**
     * Cписок доступных провайдеров для баннера
     */
    public static Set<PixelProvider> getAccessiblePixelProviders(NewPixelsValidationContext pixelsValidationContext) {
        InventoryType bannerInventoryType = PixelUtils.calculateInventoryInfo(
                pixelsValidationContext.getPlacements(),
                adGroupHasPrivateSegments(pixelsValidationContext),
                isCpmDealCampaign(pixelsValidationContext));
        return PixelUtils.getAccessibleClientProviders(
                pixelsValidationContext.getPermissionInfosForClient(),
                pixelsValidationContext.getCampaignType(),
                bannerInventoryType);
    }

    public static Set<String> getAccessiblePixelProviderNames(NewPixelsValidationContext context) {
        return getAccessiblePixelProviders(context).stream()
                .filter(Objects::nonNull)
                .map(PixelProvider::getProviderName)
                .collect(Collectors.toSet());
    }

    /**
     * Проверка на то, что группа, соответствующая данному контексту, содержит условия ретаргетинга,
     * отличные от являющихся публичными (пол/возраст), или фразы
     */
    private static Boolean adGroupHasPrivateSegments(NewPixelsValidationContext pixelsValidationContext) {
        if (pixelsValidationContext.getHasKeywordsOnAdgroup()) {
            return true;
        }
        return !StreamEx.of(pixelsValidationContext.getRetargetingConditions())
                .flatCollection(RetargetingCondition::getRules)
                .filter(Objects::nonNull)
                .flatCollection(Rule::getGoals)
                .allMatch(BannerWithPixelsValidatorHelper::isPublicSegment);
    }

    private static final List<Long> SEX_AGE_CRYPTA_IDS =
            LongStreamEx.range(2499000001L, 2499000009L).append(2499000021L, 2499000022L).boxed().toList();
    /**
     * Проверка цели на то, что она соответствует публичному сегменту крипты (пол/возраст)
     */
    private static Boolean isPublicSegment(Goal goal) {
        return SEX_AGE_CRYPTA_IDS.contains(goal.getId());
    }

    private static Boolean isCpmDealCampaign(NewPixelsValidationContext pixelsValidationContext) {
        return pixelsValidationContext.getCampaignType() == CampaignType.CPM_DEALS;
    }
}
