package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.placements.model.Placement;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;

/**
 * Класс, хранящий текущий контекст, необходимый для валидации пикселей
 * Все поля ненулевые, кроме случая, когда в валидацию приходит
 * несуществующий или несвязанный с баннером id кампании. В последнем случае campaignType == null
 */
public class NewPixelsValidationContext {

    private final List<PixelPermissionInfo> permissionInfosForClient;
    private final CampaignType campaignType;
    private final List<Placement> placements;
    private final List<RetargetingCondition> retargetingConditions;
    private final Boolean hasKeywordsOnAdgroup;
    private final AdGroupType adGroupType;

    public NewPixelsValidationContext(
            List<PixelPermissionInfo> permissionInfosForClient,
            CampaignType campaignType,
            List<Placement> placements,
            List<RetargetingCondition> retargetingConditions,
            Boolean hasKeywordsOnAdgroup, AdGroupType adGroupType) {
        this.permissionInfosForClient = permissionInfosForClient;
        this.campaignType = campaignType;
        this.placements = placements;
        this.retargetingConditions = retargetingConditions;
        this.hasKeywordsOnAdgroup = hasKeywordsOnAdgroup;
        this.adGroupType = adGroupType;
    }

    public List<PixelPermissionInfo> getPermissionInfosForClient() {
        return permissionInfosForClient;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public List<Placement> getPlacements() {
        return placements;
    }

    public List<RetargetingCondition> getRetargetingConditions() {
        return retargetingConditions;
    }

    public Boolean getHasKeywordsOnAdgroup() {
        return hasKeywordsOnAdgroup;
    }

    public AdGroupType getAdGroupType() {
        return adGroupType;
    }
}
