package ru.yandex.direct.core.entity.banner.type.pixels;

import java.util.Objects;

import ru.yandex.direct.core.entity.banner.model.pixels.ClientPixelProvider;
import ru.yandex.direct.core.entity.banner.model.pixels.PixelCampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;

public class PixelPermissionInfo {
    private PixelProvider provider;
    private CampaignType campaignType;
    private InventoryType inventoryType;

    public PixelProvider getProvider() {
        return provider;
    }

    public PixelPermissionInfo withProvider(PixelProvider provider) {
        this.provider = provider;
        return this;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public PixelPermissionInfo withCampaignType(CampaignType campaignType) {
        this.campaignType = campaignType;
        return this;
    }

    public InventoryType getInventoryType() {
        return inventoryType;
    }

    public PixelPermissionInfo withInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }

    public static PixelPermissionInfo fromDb(ClientPixelProvider clientPixelProvider) {
        return new PixelPermissionInfo()
                .withProvider(PixelProvider.fromSource(clientPixelProvider.getProvider()))
                .withCampaignType(campaignTypeFromSource(clientPixelProvider.getPixelCampaignType()))
                .withInventoryType(InventoryType.fromSource(clientPixelProvider.getCriterionType()));
    }

    public static CampaignType campaignTypeFromSource(PixelCampaignType pixelCampaignType) {
        switch (pixelCampaignType) {
            case CPM_BANNER:
                return CampaignType.CPM_BANNER;
            case CPM_DEALS:
                return CampaignType.CPM_DEALS;
            case CPM_YNDX_FRONTPAGE:
                return CampaignType.CPM_YNDX_FRONTPAGE;
            case CPM_PRICE:
                return CampaignType.CPM_PRICE;
            default:
                throw new IllegalStateException("No such value: " + pixelCampaignType);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PixelPermissionInfo that = (PixelPermissionInfo) o;
        return campaignType == that.campaignType &&
                provider == that.provider &&
                inventoryType == that.inventoryType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(provider, campaignType, inventoryType);
    }
}
