package ru.yandex.direct.core.entity.banner.type.price;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerPricesCurrency;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.currencyMissing;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class BannerPriceCurrencyValidator implements Validator<BannerPricesCurrency, Defect> {

    @Override
    public ValidationResult<BannerPricesCurrency, Defect> apply(@Nullable BannerPricesCurrency currency) {
        ItemValidationBuilder<BannerPricesCurrency, Defect> vb = ItemValidationBuilder.of(currency);

        vb.check(notNull(), currencyMissing());

        return vb.getResult();
    }
}
