package ru.yandex.direct.core.entity.banner.type.price;

import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.banner.model.BannerPricesCurrency;
import ru.yandex.direct.core.entity.banner.model.BannerPricesPrefix;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.BannerPrices.BANNER_PRICES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

public class BannerPriceMapperProvider {
    private static final JooqMapperWithSupplier<BannerPrice> MAPPER = createMapper();

    private BannerPriceMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для цен на беннере.
     */
    public static JooqMapperWithSupplier<BannerPrice> getBannerPriceMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<BannerPrice> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(BannerPrice::new)
                .map(convertibleProperty(BannerPrice.PRICE, BANNER_PRICES.PRICE,
                        BannerWithPriceUtils::roundPriceHalfUp,
                        BannerWithPriceUtils::roundPriceHalfUp))
                .map(convertibleProperty(BannerPrice.PRICE_OLD, BANNER_PRICES.PRICE_OLD,
                        BannerWithPriceUtils::roundPriceHalfUp,
                        BannerWithPriceUtils::roundPriceHalfUp))
                .map(convertibleProperty(BannerPrice.CURRENCY, BANNER_PRICES.CURRENCY,
                        BannerPricesCurrency::fromSource,
                        BannerPricesCurrency::toSource))
                .map(convertibleProperty(BannerPrice.PREFIX, BANNER_PRICES.PREFIX,
                        BannerPricesPrefix::fromSource,
                        BannerPricesPrefix::toSource))
                .build();
    }
}
