package ru.yandex.direct.core.entity.banner.type.price;

import java.util.Collection;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.banner.type.price.BannerPriceMapperProvider.getBannerPriceMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PRICES;

@Repository
public class BannerPriceRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public BannerPriceRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Возвращает цены на баннеры по списку ID баннеров
     */
    public Map<Long, BannerPrice> getBannerPricesByBannerIds(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_PRICES.BID, BANNER_PRICES.CURRENCY, BANNER_PRICES.PRICE, BANNER_PRICES.PRICE_OLD,
                        BANNER_PRICES.PREFIX)
                .from(BANNER_PRICES)
                .where(BANNER_PRICES.BID.in(bannerIds))
                .fetchMap(BANNER_PRICES.BID, getBannerPriceMapper()::fromDb);
    }
}
