package ru.yandex.direct.core.entity.banner.type.price;

import java.math.BigDecimal;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.math.BigDecimal.ZERO;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.priceGreaterThanMax;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.priceLessThanMin;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.priceMissing;
import static ru.yandex.direct.core.entity.banner.type.price.BannerWithPriceConstants.MAX_BANNER_PRICE;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.greaterThan;
import static ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan;

@ParametersAreNonnullByDefault
public class BannerPriceValidator implements Validator<BigDecimal, Defect> {

    private final boolean isPriceRequired;

    private BannerPriceValidator(boolean isPriceRequired) {
        this.isPriceRequired = isPriceRequired;
    }

    public static BannerPriceValidator optionalBannerPriceValidator() {
        return new BannerPriceValidator(false);
    }

    public static BannerPriceValidator requiredBannerPriceValidator() {
        return new BannerPriceValidator(true);
    }

    @Override
    public ValidationResult<BigDecimal, Defect> apply(@Nullable BigDecimal price) {
        ItemValidationBuilder<BigDecimal, Defect> vb = ItemValidationBuilder.of(price);

        vb
                .check(notNull(), priceMissing(), When.isTrue(isPriceRequired))
                .check(greaterThan(ZERO), priceLessThanMin(ZERO), When.isValid())
                .check(notGreaterThan(MAX_BANNER_PRICE), priceGreaterThanMax(MAX_BANNER_PRICE), When.isValid());

        return vb.getResult();
    }
}
