package ru.yandex.direct.core.entity.banner.type.price;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.banner.model.BannerWithPrice;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.price.BannerPriceValidator.optionalBannerPriceValidator;
import static ru.yandex.direct.core.entity.banner.type.price.BannerPriceValidator.requiredBannerPriceValidator;
import static ru.yandex.direct.core.entity.banner.type.price.BannerWithPriceConstraints.isOldPriceGreaterThanCurrent;
import static ru.yandex.direct.validation.builder.When.isTrue;

@Component
public class BannerWithBannerPriceValidatorProvider {

    public Validator<BannerWithPrice, Defect> bannerPriceValidator() {

        return banner -> {

            BannerPrice bannerPrice = banner.getBannerPrice();
            if (bannerPrice == null) {
                return ValidationResult.success(banner);
            }

            ModelItemValidationBuilder<BannerWithPrice> vbOfBanner = ModelItemValidationBuilder.of(banner);

            ModelItemValidationBuilder<BannerPrice> vbOfBannerPrice =
                    vbOfBanner.modelItem(BannerWithPrice.BANNER_PRICE);


            vbOfBannerPrice.item(BannerPrice.PRICE)
                    .checkBy(requiredBannerPriceValidator(), When.isValid());

            vbOfBannerPrice.item(BannerPrice.PRICE_OLD)
                    .checkBy(optionalBannerPriceValidator(), When.isValid());

            vbOfBannerPrice.item(BannerPrice.CURRENCY)
                    .checkBy(new BannerPriceCurrencyValidator(), When.isValid());

            vbOfBannerPrice.check(isOldPriceGreaterThanCurrent(),
                    When.isValidAnd(isTrue(bannerPrice.getPriceOld() != null)));

            return vbOfBanner.getResult();
        };
    }
}
