package ru.yandex.direct.core.entity.banner.type.price;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPrice;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithPriceAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithPrice> {

    private final BannerWithBannerPriceValidatorProvider validatorProvider;

    public BannerWithPriceAddValidationTypeSupport(BannerWithBannerPriceValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithPrice> getTypeClass() {
        return BannerWithPrice.class;
    }

    @Override
    public ValidationResult<List<BannerWithPrice>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithPrice>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerPriceValidator())
                .getResult();
    }
}
