package ru.yandex.direct.core.entity.banner.type.price;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.priceGreaterThanOld;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@ParametersAreNonnullByDefault
public class BannerWithPriceConstraints {

    private BannerWithPriceConstraints() {
    }

    public static Constraint<BannerPrice, Defect> isOldPriceGreaterThanCurrent() {
        return fromPredicate(bp -> bp.getPriceOld().compareTo(bp.getPrice()) > 0, priceGreaterThanOld());
    }
}
