package ru.yandex.direct.core.entity.banner.type.price;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.banner.model.BannerWithPrice;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractNestedRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.Tables;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerPricesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.core.entity.banner.type.price.BannerPriceMapperProvider.getBannerPriceMapper;
import static ru.yandex.direct.dbschema.ppc.tables.BannerPrices.BANNER_PRICES;

@Component
@ParametersAreNonnullByDefault
public class BannerWithPriceRepositoryTypeSupport
        extends AbstractNestedRelatedEntityUpsertRepositoryTypeSupport
        <BannerWithPrice, BannerPricesRecord, BannerPrice> {

    @Autowired
    public BannerWithPriceRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,
                BANNER_PRICES.BID,
                getBannerPriceMapper(),
                BannerWithPrice.BANNER_PRICE,
                x -> x.getPrice() != null);
    }

    /**
     * Добавляет цены на товар на баннерах. В случае если цена с таким bannerId уже имеется - обновляет ее.
     * Метод используется для транзакций с общим контекстом
     *
     * @param banners Список баннеров
     * @param context Контекст для использования в транзакции
     */
    @Override
    protected void upsertEntity(DSLContext context, Collection<BannerWithPrice> banners) {
        InsertHelper<BannerPricesRecord> helper = new InsertHelper<>(context, Tables.BANNER_PRICES);

        banners.forEach(banner -> {
            helper.add(getJooqMapper(), banner.getBannerPrice());
            helper.set(Tables.BANNER_PRICES.BID, banner.getId());
            helper.newRecord();
        });

        helper.onDuplicateKeyUpdate()
                .set(Tables.BANNER_PRICES.CURRENCY, MySQLDSL.values(Tables.BANNER_PRICES.CURRENCY))
                .set(Tables.BANNER_PRICES.PRICE, MySQLDSL.values(Tables.BANNER_PRICES.PRICE))
                .set(Tables.BANNER_PRICES.PRICE_OLD, MySQLDSL.values(Tables.BANNER_PRICES.PRICE_OLD))
                .set(Tables.BANNER_PRICES.PREFIX, MySQLDSL.values(Tables.BANNER_PRICES.PREFIX));

        helper.executeIfRecordsAdded();
    }

    @Override
    public Class<BannerWithPrice> getTypeClass() {
        return BannerWithPrice.class;
    }
}
