package ru.yandex.direct.core.entity.banner.type.price;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithPrice;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithPriceUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithPrice> {

    @Override
    public Class<BannerWithPrice> getTypeClass() {
        return BannerWithPrice.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithPrice> appliedChanges) {
        return appliedChanges.changed(BannerWithPrice.BANNER_PRICE);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithPrice> appliedChanges) {
        return appliedChanges.changed(BannerWithPrice.BANNER_PRICE);
    }
}
