package ru.yandex.direct.core.entity.banner.type.price;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPrice;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithPriceUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithPrice> {

    private final BannerWithBannerPriceValidatorProvider validatorProvider;

    public BannerWithPriceUpdateValidationTypeSupport(BannerWithBannerPriceValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithPrice> getTypeClass() {
        return BannerWithPrice.class;
    }

    @Override
    public ValidationResult<List<BannerWithPrice>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithPrice>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerPriceValidator())
                .getResult();
    }
}
