package ru.yandex.direct.core.entity.banner.type.pricepackage;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.model.BannerWithPricePackage;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.creative.repository.CreativeRepository;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.priceSalesFullnessViolated;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;


public class BannerWithPricePackageFullnessModelChangesValidator
        extends BannerWithPricePackageFullnessValidatorBase<ModelChanges<BannerWithSystemFields>> {

    BannerWithPricePackageFullnessModelChangesValidator(int shard,
                                                           List<BannerWithPricePackage> excludeBanners,
                                                           CampaignTypedRepository campaignTypedRepository,
                                                           AdGroupRepository adGroupRepository,
                                                           BannerTypedRepository bannerRepository,
                                                           CreativeRepository creativeRepository) {
        super(shard, excludeBanners, campaignTypedRepository, adGroupRepository, bannerRepository, creativeRepository);
    }

    @Override
    Constraint<ModelChanges<BannerWithSystemFields>, Defect> canExcludeBanner(Set<Long> breakingBannerIds) {
        return fromPredicate(b -> !breakingBannerIds.contains(b.getId()), priceSalesFullnessViolated());
    }
}
