package ru.yandex.direct.core.entity.banner.type.pricepackage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPricePackage;
import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.banner.service.type.update.BannerUpdateOperationTypeSupportFacade;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.campaign.service.CampaignWithPricePackageUtils;
import ru.yandex.direct.core.entity.creative.repository.CreativeRepository;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithPricePackageFullnessValidatorFactory {

    private final BannerUpdateOperationTypeSupportFacade operationTypeSupportFacade;
    private final CampaignTypedRepository campaignTypedRepository;
    private final AdGroupRepository adGroupRepository;
    private final BannerTypedRepository bannerRepository;
    private final CreativeRepository creativeRepository;

    @Autowired
    public BannerWithPricePackageFullnessValidatorFactory(
            BannerUpdateOperationTypeSupportFacade operationTypeSupportFacade,
            CampaignTypedRepository campaignTypedRepository,
            AdGroupRepository adGroupRepository,
            BannerTypedRepository bannerRepository,
            CreativeRepository creativeRepository) {
        this.operationTypeSupportFacade = operationTypeSupportFacade;
        this.campaignTypedRepository = campaignTypedRepository;
        this.adGroupRepository = adGroupRepository;
        this.bannerRepository = bannerRepository;
        this.creativeRepository = creativeRepository;
    }

    public BannerWithPricePackageFullnessValidator createForUpdate(
            BannersUpdateOperationContainer container,
            Map<Integer, AppliedChanges<BannerWithPricePackage>> appliedChanges) {
        List<BannerWithPricePackage> excludeBanners = getActiveBannersWithChangedModeration(container,
                appliedChanges);

        return new BannerWithPricePackageFullnessValidator(
                container.getShard(),
                excludeBanners,
                campaignTypedRepository,
                adGroupRepository,
                bannerRepository,
                creativeRepository
        );
    }

    public BannerWithPricePackageFullnessModelChangesValidator createForSuspendResume(
            int shard,
            List<BannerWithPricePackage> excludeBanners) {

        return new BannerWithPricePackageFullnessModelChangesValidator(
                shard,
                excludeBanners,
                campaignTypedRepository,
                adGroupRepository,
                bannerRepository,
                creativeRepository
        );
    }

    private List<BannerWithPricePackage> getActiveBannersWithChangedModeration(
            BannersUpdateOperationContainer container,
            Map<Integer, AppliedChanges<BannerWithPricePackage>> appliedChanges) {
        List<AppliedChanges<BannerWithPricePackage>> appliedChangesList = new ArrayList<>(appliedChanges.values());
        Set<Long> bannerIdsWithChangedModeration = operationTypeSupportFacade.getNeedModerationIds(container,
                appliedChangesList);

        return StreamEx.of(appliedChangesList)
                .filter(CampaignWithPricePackageUtils::wasBannerActive)
                .map(AppliedChanges::getModel)
                .filter(banner -> bannerIdsWithChangedModeration.contains(banner.getId()))
                .toList();
    }
}
