package ru.yandex.direct.core.entity.banner.type.pricepackage;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPricePackage;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithPricePackageUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithPricePackage> {

    private final BannerWithPricePackageValidatorProvider validatorProvider;

    public BannerWithPricePackageUpdateValidationTypeSupport(BannerWithPricePackageValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithPricePackage> getTypeClass() {
        return BannerWithPricePackage.class;
    }

    @Override
    public ValidationResult<List<BannerWithPricePackage>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithPricePackage>, Defect> vr,
            Map<Integer, AppliedChanges<BannerWithPricePackage>> appliedChangesForValidModelChanges) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithPricePackageValidator(container,
                        appliedChangesForValidModelChanges))
                .getResult();
    }
}
