package ru.yandex.direct.core.entity.banner.type.pricepackage;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithPricePackage;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

@Component
public class BannerWithPricePackageValidatorProvider {

    private final BannerWithPricePackageFullnessValidatorFactory pricePackageFullnessValidatorFactory;

    @Autowired
    public BannerWithPricePackageValidatorProvider(
            BannerWithPricePackageFullnessValidatorFactory pricePackageFullnessValidatorFactory) {
        this.pricePackageFullnessValidatorFactory = pricePackageFullnessValidatorFactory;
    }

    public Validator<BannerWithPricePackage, Defect> bannerWithPricePackageValidator(
            BannersUpdateOperationContainer container,
            Map<Integer, AppliedChanges<BannerWithPricePackage>> appliedChanges) {
        BannerWithPricePackageFullnessValidator pricePackageFullnessValidator =
                pricePackageFullnessValidatorFactory.createForUpdate(container, appliedChanges);

        return banner -> {
            ModelItemValidationBuilder<BannerWithPricePackage> builder = ModelItemValidationBuilder.of(banner);

            builder.checkBy(pricePackageFullnessValidator);

            return builder.getResult();
        };
    }
}
