package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class BannerSitelinksRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public BannerSitelinksRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Получает список id баннеров по id привязанных к ним наборов быстрых ссылок
     *
     * @param shard          шард
     * @param sitelinkSetIds коллекция id наборов быстрых ссылок, для которых ищутся привязанные баннеры
     * @return мапа id набора быстрых ссылок - список id привязанных к ней баннеров
     */
    public Map<Long, List<Long>> getBannerIdsBySitelinkSetIds(int shard, Collection<Long> sitelinkSetIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS.BID, BANNERS.SITELINKS_SET_ID)
                .from(BANNERS)
                .where(BANNERS.SITELINKS_SET_ID.in(sitelinkSetIds))
                .fetchGroups(BANNERS.SITELINKS_SET_ID, BANNERS.BID);
    }
}
