package ru.yandex.direct.core.entity.banner.type.sitelink;

import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLandingAndSitelinks;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.invalidSitelinkSetIdUsage;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

public class BannerWithHrefAndTurboLandingAndSitelinksConstraints {

    private BannerWithHrefAndTurboLandingAndSitelinksConstraints() {
        // only static methods
    }

    static <B extends BannerWithHrefAndTurboLandingAndSitelinks> Constraint<B, Defect>
    hrefOrTurboIsSetIfSitelinkSetNotNull(Boolean clientHasDesktopTurbolandingFeature) {
        return fromPredicate(b -> b.getSitelinksSetId() == null ||
                        b.getHref() != null ||
                        (clientHasDesktopTurbolandingFeature && b.getTurboLandingId() != null),
                invalidSitelinkSetIdUsage());
    }
}
