package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLandingAndSitelinks;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithHrefAndTurboLandingAndSitelinksUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithHrefAndTurboLandingAndSitelinks> {

    private final BannerWithHrefAndTurboLandingAndSitelinksValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefAndTurboLandingAndSitelinksUpdateValidationTypeSupport(
            BannerWithHrefAndTurboLandingAndSitelinksValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHrefAndTurboLandingAndSitelinks> getTypeClass() {
        return BannerWithHrefAndTurboLandingAndSitelinks.class;
    }

    @Override
    public ValidationResult<List<BannerWithHrefAndTurboLandingAndSitelinks>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithHrefAndTurboLandingAndSitelinks>, Defect> vr) {
        if (container.isPartOfComplexOperation()) {
            return vr;
        }

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithHrefAndTurboLandingAndSitelinksValidator(container))
                .getResult();
    }
}
