package ru.yandex.direct.core.entity.banner.type.sitelink;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndTurboLandingAndSitelinks;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.sitelink.BannerWithHrefAndTurboLandingAndSitelinksConstraints.hrefOrTurboIsSetIfSitelinkSetNotNull;

@Component
public class BannerWithHrefAndTurboLandingAndSitelinksValidatorProvider {

    public Validator<BannerWithHrefAndTurboLandingAndSitelinks, Defect>
    bannerWithHrefAndTurboLandingAndSitelinksValidator(BannersOperationContainer container) {
        return banner -> {
            ModelItemValidationBuilder<BannerWithHrefAndTurboLandingAndSitelinks> builder =
                    ModelItemValidationBuilder.of(banner);

            builder.check(hrefOrTurboIsSetIfSitelinkSetNotNull(
                    container.isFeatureEnabledForClient(FeatureName.DESKTOP_LANDING)));

            return builder.getResult();
        };
    }
}
