package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;

@Component
public class BannerWithSitelinksAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithSitelinks> {

    @Override
    public Class<BannerWithSitelinks> getTypeClass() {
        return BannerWithSitelinks.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithSitelinks> models) {
        models.forEach(banner -> {
            var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);
            banner.setStatusSitelinksModerate(banner.getSitelinksSetId() == null || effectiveSaveDraft ?
                    BannerStatusSitelinksModerate.NEW : BannerStatusSitelinksModerate.READY);
        });
    }
}
