package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.Map;

import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.sitelinksSetNotFound;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefects.requiredSitelinkWithTurboHrefOrTurbolandingId;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

public class BannerWithSitelinksConstraints {

    private BannerWithSitelinksConstraints() {
        // only static methods
    }

    static Constraint<Long, Defect> sitelinksSetExists(
            Map<Long, SitelinkSet> existingSitelinkSets) {
        return fromPredicate(existingSitelinkSets::containsKey,
                sitelinksSetNotFound());
    }

    static Constraint<Sitelink, Defect> isTurboSitelink() {
        return fromPredicate(sitelink -> sitelink.getHref() == null && sitelink.getTurboLandingId() != null,
                requiredSitelinkWithTurboHrefOrTurbolandingId());
    }
}
