package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinksModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithSitelinksModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithSitelinksModeration> {

    private BannerWithChildrenModerationProvider<BannerWithSitelinksModeration> provider;

    @Autowired
    public BannerWithSitelinksModerationUpdateOperationTypeSupport(
            List<BannerWithSitelinksModerationProcessor<? extends BannerWithSitelinksModeration>> processors) {
        provider = new BannerWithChildrenModerationProvider<>(DefaultBannerWithSitelinksModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithSitelinksModeration> getTypeClass() {
        return BannerWithSitelinksModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithSitelinksModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
