package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.core.grut.api.BannerGrutApi;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.BannerV2;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptyMap;
import static java.util.Collections.emptySet;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class BannerWithSitelinksRepositoryTypeSupport extends AbstractBannerRepositoryTypeSupport<BannerWithSitelinks> {

    private static final JooqMapper<BannerWithSitelinks> MAPPER = createMapper();

    private static final Set<ModelProperty<? super BannerWithSitelinks, ?>> GRUT_PROPERTIES =
            Set.of(BannerWithSitelinks.SITELINKS_SET_ID);

    @Autowired
    public BannerWithSitelinksRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends BannerWithSitelinks> void fillFromRecord(M model, Record record) {
        MAPPER.fromDb(record, model);
    }

    @Override
    public Class<BannerWithSitelinks> getTypeClass() {
        return BannerWithSitelinks.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, BannerWithSitelinks model) {
        insertHelperAggregator.getOrCreate(BANNERS).add(MAPPER, model);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<BannerWithSitelinks>> appliedChanges) {
        updateHelperAggregator.getOrCreate(BANNERS.BID).processUpdateAll(MAPPER, appliedChanges);
    }

    private static JooqMapper<BannerWithSitelinks> createMapper() {
        return JooqMapperBuilder.<BannerWithSitelinks>builder()
                .readProperty(BannerWithSitelinks.ID, fromField(BANNERS.BID))
                .map(property(BannerWithSitelinks.SITELINKS_SET_ID, BANNERS.SITELINKS_SET_ID))
                .map(convertibleProperty(BannerWithSitelinks.STATUS_SITELINKS_MODERATE,
                        BANNERS.STATUS_SITELINKS_MODERATE,
                        BannerStatusSitelinksModerate::fromSource,
                        BannerStatusSitelinksModerate::toSource))
                .build();
    }

    @Override
    public Set<ModelProperty<? super BannerWithSitelinks, ?>> getGrutSupportedProperties() {
        return GRUT_PROPERTIES;
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(@NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
                                                       @NotNull Collection<AppliedChanges<BannerWithSitelinks>> appliedChangesList,
                                                       @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (var appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithSitelinks.SITELINKS_SET_ID)) {
                Long id = appliedChanges.getModel().getId();
                ModifiedPaths modifiedPaths;
                var newValue = appliedChanges.getNewValue(BannerWithSitelinks.SITELINKS_SET_ID);
                if (newValue != null) {
                    Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                    BannerV2.TBannerV2Spec.TSitelinkSet grutSitelinkSet = BannerGrutApi.Companion.toTSitelinkSet(
                            operationContainer.getSitelinkSets().get(newValue),
                            ObjectUtils.firstNonNull(operationContainer.getTurboLandings(), emptyMap()));
                    bannerBuilder.getSpecBuilder().setSitelinkSet(grutSitelinkSet);
                    modifiedPaths = new ModifiedPaths(Set.of("/spec/sitelink_set"), emptySet());
                } else {
                    // TODO : удаление в этом месте должно быть таким
                    // modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/sitelink_set"));
                    // или
                    // modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/sitelink_set/*"));
                    // пока что ORM отвечает ошибкой на такое (из-за того, что sitelink_set -- отдельная колонка)
                    // поэтому пока закостылил тем, что обнуляем все вложенные в TSitelinkSet поля
                    // когда в ORM появится реализация * или полноценная поддержка удаления значения-колонки,
                    // можно будет заменить костыль на нормальный способ
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of(
                            "/spec/sitelink_set/id",
                            "/spec/sitelink_set/sitelinks"
                    ));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
