package ru.yandex.direct.core.entity.banner.type.sitelink;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithSitelinksUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithSitelinks> {

    @Override
    public Class<BannerWithSitelinks> getTypeClass() {
        return BannerWithSitelinks.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithSitelinks> appliedChanges) {
        return appliedChanges.changed(BannerWithSitelinks.SITELINKS_SET_ID);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithSitelinks> appliedChanges) {
        return appliedChanges.changed(BannerWithSitelinks.SITELINKS_SET_ID);
    }
}
