package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithSitelinksUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithSitelinks> {

    private final BannerWithSitelinksValidatorProvider validatorProvider;

    @Autowired
    public BannerWithSitelinksUpdateValidationTypeSupport(
            BannerWithSitelinksValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithSitelinks> getTypeClass() {
        return BannerWithSitelinks.class;
    }

    @Override
    public ValidationResult<List<BannerWithSitelinks>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithSitelinks>, Defect> vr) {
        if (container.isPartOfComplexOperation()) {
            return vr;
        }

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithSitelinksValidator(container))
                .getResult();
    }
}
