package ru.yandex.direct.core.entity.banner.type.sitelink;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks.SITELINKS_SET_ID;
import static ru.yandex.direct.core.entity.banner.type.sitelink.BannerWithSitelinksConstraints.isTurboSitelink;
import static ru.yandex.direct.core.entity.banner.type.sitelink.BannerWithSitelinksConstraints.sitelinksSetExists;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Component
public class BannerWithSitelinksValidatorProvider {

    public Validator<BannerWithSitelinks, Defect> bannerWithSitelinksValidator(
            BannersOperationContainer container) {
        Map<Long, SitelinkSet> sitelinkSets = container.getSitelinkSets();

        return banner -> {
            SitelinkSet sitelinkSet = sitelinkSets.get(banner.getSitelinksSetId());

            ModelItemValidationBuilder<BannerWithSitelinks> builder = ModelItemValidationBuilder.of(banner);

            builder.item(SITELINKS_SET_ID)
                    .check(validId())
                    .check(sitelinksSetExists(sitelinkSets));

            return builder.getResult();
        };
    }

    private Validator<BannerWithSitelinks, Defect> compatibilityWithPayForConversionValidator(
            SitelinkSet sitelinkSet) {
        return banner -> {
            ModelItemValidationBuilder<BannerWithSitelinks> builder = ModelItemValidationBuilder.of(banner);

            // код странный, но делаем так, потому что
            // в веб-интерфейсе есть взаимная валидация баннеров с сайтлинками
            // но сохраняются они по-отдельности
            // и сохранении баннера надо показать, в каком сайтлинке проблема
            // оригинальный код написали в тикете DIRECT-114505
            builder.item(SITELINKS_SET_ID).list(sitelinkSet.getSitelinks(), "siteLink")
                    .checkEach(isTurboSitelink());
            return builder.getResult();
        };
    }
}
