package ru.yandex.direct.core.entity.banner.type.system;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;

import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isInternalBanner;

public class BannerStatusShowHelper {

    /**
     * Возвращает статус показа баннера. По дефолту значение true
     * Для внутреннего обявления разрешаем брать переданное значение из модели
     * Копия метода getStatusShow для старых моделей баннера
     */
    public static Boolean getStatusShowOld(OldBanner banner) {
        if (banner.getBannerType() == OldBannerType.INTERNAL && banner.getStatusShow() != null) {
            return banner.getStatusShow();
        }

        return true;
    }

    /**
     * Копия метода getStatusShow для новый моделей баннера
     */
    public static Boolean getStatusShowNew(BannerWithSystemFields banner) {
        if (isInternalBanner(banner) && banner.getStatusShow() != null) {
            return banner.getStatusShow();
        }

        return true;
    }
}
