package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.util.Collections.emptyList;
import static ru.yandex.direct.core.entity.banner.repository.BannerRepositoryConstants.BANNER_CLASS_TO_TYPE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

/**
 * Саппорт для записи BANNER_TYPE в базу
 */
@Component
@ParametersAreNonnullByDefault
public class BannerWithBannerTypeRepositoryTypeSupport
        extends AbstractBannerRepositoryTypeSupport<Banner> {

    @Autowired
    public BannerWithBannerTypeRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return emptyList();
    }

    @Override
    public <M extends Banner> void fillFromRecord(M model, Record record) {
    }

    @Override
    public Class<Banner> getTypeClass() {
        return Banner.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, Banner banner) {
        var insertHelper = insertHelperAggregator.getOrCreate(BANNERS);
        insertHelper.set(BANNERS.BANNER_TYPE, getBannerType(banner));
    }

    private BannersBannerType getBannerType(Banner banner) {
        BannersBannerType bannerType = BANNER_CLASS_TO_TYPE.get(banner.getClass());
        checkNotNull(bannerType, "Unsupported type: " + banner.getClass());
        return bannerType;
    }
}
