package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithBsBannerId;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.util.function.Function.identity;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithBsBannerIdRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithBsBannerId> {

    @Autowired
    public BannerWithBsBannerIdRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithBsBannerId.BS_BANNER_ID, BANNERS.BANNER_ID,
                identity(), identity());
    }

    @Override
    public Class<BannerWithBsBannerId> getTypeClass() {
        return BannerWithBsBannerId.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithBsBannerId model) {
        checkFieldIsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithBsBannerId>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldIsNotNull(x.getModel()));
    }

    private void checkFieldIsNotNull(BannerWithBsBannerId model) {
        checkNotNull(model.getBsBannerId(),
                "BsBannerId is null. Use support to fill bsBannerId. BannerId: " + model.getId());
    }
}
