package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithLastChange;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.util.function.Function.identity;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithLastChangeRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithLastChange> {

    @Autowired
    public BannerWithLastChangeRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithLastChange.LAST_CHANGE, BANNERS.LAST_CHANGE, identity(),
                identity());
    }

    @Override
    public Class<BannerWithLastChange> getTypeClass() {
        return BannerWithLastChange.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithLastChange model) {
        checkFieldIsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithLastChange>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldIsNotNull(x.getModel()));
    }

    private void checkFieldIsNotNull(BannerWithLastChange model) {
        checkNotNull(model.getLastChange(),
                "LastChange is null. Use support to fill lastChange. BannerId: " + model.getId());
    }
}
