package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithStatusActive;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithStatusActiveRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithStatusActive> {

    @Autowired
    public BannerWithStatusActiveRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithStatusActive.STATUS_ACTIVE, BANNERS.STATUS_ACTIVE,
                BannerWithSystemFieldsMappings::statusActiveFromDb,
                BannerWithSystemFieldsMappings::statusActiveToDb);
    }

    @Override
    public Class<BannerWithStatusActive> getTypeClass() {
        return BannerWithStatusActive.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithStatusActive model) {
        checkFieldIsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithStatusActive>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldIsNotNull(x.getModel()));
    }

    private void checkFieldIsNotNull(BannerWithStatusActive model) {
        checkNotNull(model.getStatusActive(),
                "StatusActive is null. Use support to fill statusActive. BannerId: " + model.getId());
    }
}
