package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithStatusArchived;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithStatusArchivedRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithStatusArchived> {

    @Autowired
    public BannerWithStatusArchivedRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithStatusArchived.STATUS_ARCHIVED, BANNERS.STATUS_ARCH,
                BannerWithSystemFieldsMappings::statusArchivedFromDb,
                BannerWithSystemFieldsMappings::statusArchivedToDb);
    }

    @Override
    public Class<BannerWithStatusArchived> getTypeClass() {
        return BannerWithStatusArchived.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithStatusArchived model) {
        checkFieldIsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithStatusArchived>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldIsNotNull(x.getModel()));
    }

    private void checkFieldIsNotNull(BannerWithStatusArchived model) {
        checkNotNull(model.getStatusArchived(),
                "StatusArchived is null. Use support to fill statusArchived. BannerId: " + model.getId());
    }
}
