package ru.yandex.direct.core.entity.banner.type.system;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithStatusArchived;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.isNotArchivedNew;


@Component
public class BannerWithStatusArchivedUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithStatusArchived> {

    @Override
    public Class<BannerWithStatusArchived> getTypeClass() {
        return BannerWithStatusArchived.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithStatusArchived>>, Defect> validateBeforeApply(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithStatusArchived>>, Defect> vr,
            Map<Long, BannerWithStatusArchived> unmodifiedModels) {
        return new ListValidationBuilder<>(vr)
                .checkEach(isNotArchivedNew(unmodifiedModels), When.isValid())
                .getResult();
    }
}
