package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithStatusBsSynced;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithStatusBsSyncedRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithStatusBsSynced> {

    @Autowired
    public BannerWithStatusBsSyncedRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithStatusBsSynced.STATUS_BS_SYNCED, BANNERS.STATUS_BS_SYNCED,
                BannerWithSystemFieldsMappings::statusBsSyncedFromDb,
                BannerWithSystemFieldsMappings::statusBsSyncedToDb);
    }

    @Override
    public Class<BannerWithStatusBsSynced> getTypeClass() {
        return BannerWithStatusBsSynced.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithStatusBsSynced model) {
        checkFieldIsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithStatusBsSynced>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldIsNotNull(x.getModel()));
    }

    private void checkFieldIsNotNull(BannerWithStatusBsSynced model) {
        checkNotNull(model.getStatusBsSynced(),
                "StatusBsSynced is null. Use support to fill statusBsSynced. BannerId: " + model.getId());
    }
}
