package ru.yandex.direct.core.entity.banner.type.system;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithStatusShow;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithStatusShowRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithStatusShow> {

    @Autowired
    public BannerWithStatusShowRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithStatusShow.STATUS_SHOW, BANNERS.STATUS_SHOW,
                BannerWithSystemFieldsMappings::statusShowFromDb,
                BannerWithSystemFieldsMappings::statusShowToDb);
    }

    @Override
    public Class<BannerWithStatusShow> getTypeClass() {
        return BannerWithStatusShow.class;
    }

    @Override
    public void checkBeforeInsert(BannerWithStatusShow model) {
        checkFieldIsNotNull(model);
    }

    @Override
    public void checkBeforeUpdate(Collection<AppliedChanges<BannerWithStatusShow>> appliedChanges) {
        appliedChanges.forEach(x -> checkFieldIsNotNull(x.getModel()));
    }

    private void checkFieldIsNotNull(BannerWithStatusShow model) {
        checkNotNull(model.getStatusShow(),
                "StatusShow is null. Use support to fill statusShow. BannerId: " + model.getId());
    }
}
