package ru.yandex.direct.core.entity.banner.type.system;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithStatusShow;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.forbiddenToChange;
import static ru.yandex.direct.core.validation.ValidationUtils.addErrorIfPropertyChanged;

@Component
public class BannerWithStatusShowUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithStatusShow> {

    @Override
    public Class<BannerWithStatusShow> getTypeClass() {
        return BannerWithStatusShow.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithStatusShow>>, Defect> preValidate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithStatusShow>>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(statusShowChangedValidator(container))
                .getResult();
    }

    private static Validator<ModelChanges<BannerWithStatusShow>, Defect> statusShowChangedValidator(
            BannersUpdateOperationContainer container) {
        return mc -> {
            ModelChangesValidationBuilder<BannerWithStatusShow> vb = ModelChangesValidationBuilder.of(mc);
            // для баннера внутренней рекламы разрешаем менять statusShow
            if (!InternalBanner.class.isAssignableFrom(container.getRuntimeClass(mc.getId()))) {
                addErrorIfPropertyChanged(mc, vb, BannerWithStatusShow.STATUS_SHOW, forbiddenToChange());
            }
            return vb.getResult();
        };
    }

}
